<?php
/**
 * automatic theme setup functions
 */
if ( ! defined( 'ABSPATH' ) ) {
    die( 'Cheatin\' huh?' );
}

/**
 * Shortcode Illution
 */

require( AUTOMATIC_DIR . '/inc/class_theme_base.php' );
require( AUTOMATIC_DIR . '/inc/sidebars.php' );

require_once( automatic_admin . '/functions.php' );
require_once( automatic_functions . '/functions.php' );
require_once( automatic_metaboxes . '/functions.php' );
/**
 * Resize Image
 */
add_image_size( 'automatic-image-product-xsmall', 70, 70, true);
add_image_size( 'automatic-image-product', 435, 435, true);
add_image_size( 'automatic-image-product-small', 240, 240, true);
add_image_size( 'automatic-image-product-list', 200, 200, true);
add_image_size( 'automatic-image-post-square', 480, 480, true);
add_image_size( 'automatic-image-product-slide', 370, 400, true);
add_image_size( 'automatic-image-product-gallery', 60, 60, true);

/**
 * Enqueue scripts
 */

add_action('admin_enqueue_scripts', 'automatic_admin_scripts');
function automatic_admin_scripts() {
	wp_enqueue_style('automatic_admin_css', automatic_css . '/admin.css', false);
	wp_register_script('automatic_admin_js', automatic_js . '/admin.js', array('common', 'jquery', 'media-upload', 'thickbox'), automatic_version, true);
	wp_enqueue_script('automatic_admin_js');
}
add_action('admin_enqueue_scripts', 'automatic_admin_css');
function automatic_admin_css() {
	wp_enqueue_style('automatic_admin_css', automatic_css . '/admin.css', true);
}

function automatic_fonts_url() {
    $font_url = '';
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'automatic' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Poppins|Lato:100,300,400,700,900,100italic,300italic,400italic,700italic,900italic&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}
add_action( 'wp_enqueue_scripts', 'automatic_enqueue_scripts',1000 );
function automatic_enqueue_scripts() {
	$automatic_settings = automatic_settings();
	$automatic__styles = automatic_theme_styles();
	$automatic__scripts = automatic_theme_scripts();
	// comment reply
	if ( is_singular() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
	}
	wp_enqueue_style('automatic-fonts', automatic_fonts_url(), array(), automatic_version );
	wp_enqueue_style('bootstrap',$automatic__styles['bootstrap'],array(), automatic_version); 
	wp_enqueue_style('font-awesome',$automatic__styles['awesome'],array(), automatic_version);
	wp_enqueue_style('automatic-theme',$automatic__styles['theme'] ,array(), automatic_version); 
	wp_enqueue_style('automatic-header',$automatic__styles['header'],array(), automatic_version); 
	wp_enqueue_style('Pe-icon-7-stroke',$automatic__styles['pe-icon'],array(), automatic_version);
	wp_enqueue_style('automatic-styles', get_stylesheet_uri());
	wp_enqueue_style('automatic-color',$automatic__styles['config-color'] ,array(), automatic_version);
	wp_enqueue_style('automatic-font',$automatic__styles['config-font'] ,array(), automatic_version); 
	wp_enqueue_style('automatic-flexslider',$automatic__styles['flexslider'] ,array(), automatic_version);
	wp_enqueue_style('automatic-reponsive',$automatic__styles['reponsive'] ,array(), automatic_version);

	wp_enqueue_script('bootstrap',$automatic__scripts['bootstrap'] ,array( 'jquery' ), '1.0', true);
	wp_enqueue_script('ui',$automatic__scripts['ui'] ,array( 'jquery' ), '1.0', true); 
	wp_enqueue_script('countdownTimer',$automatic__scripts['countdownTimer'] ,array( 'jquery' ), '1.0', true);
	wp_enqueue_script('automatic-js-plugin',$automatic__scripts['plugin'] ,array( 'jquery' ), '1.0', true);
	wp_enqueue_script('automatic-js-flexslider',$automatic__scripts['flexslider'] ,array( 'jquery' ), '1.0', true);
	wp_enqueue_script('automatic-js-main',$automatic__scripts['main'] ,array( 'jquery' ), '1.0', true);
	wp_enqueue_script('automatic-js-customs',$automatic__scripts['custom'] ,array( 'jquery' ), '1.0', true);
	wp_enqueue_script('automatic-js-carousel',$automatic__scripts['carousel'] ,array( 'jquery' ), '1.0', true);
	wp_localize_script( 'automatic-js-main', 'automatic_ajax_product', array(
        'ajaxurl'       => admin_url( 'admin-ajax.php' )
    ));
} 